<?php
if(!isset($_COOKIE["idUsuario"])) {
  header("Location: login.php");
}
header('Access-Control-Allow-Origin: *');
require_once("inc/functions.php");

$page="bl";
$modulo=0;

if(isset($_GET["id"]))
{
    $result=query("SELECT * FROM packinglist WHERE idPackingList=" . $_GET["id"]);
    $bl = mysqli_fetch_array($result);
}
?>
<html
  lang="en"
  class="light-style layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
>
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>
    <title>BL <?php echo $bl["BL"]; ?></title>
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/log-truck.svg" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/bs-stepper/bs-stepper.css">
    <link rel="stylesheet" type="text/css" href="assets/vendor/css/rtl/core.css" class="template-customizer-core-css">
    <link rel="stylesheet" type="text/css" href="assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <script src="assets/js/config.js"></script>
    <style>
      .dropdown-menu.show {
        display: inline-block !important;
        width: auto !important;
      }
    </style>
  </head>

  <body>
    
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php require_once("inc/menu/aside.php"); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php require_once("inc/menu/navbar.php"); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content --> 

            <div class="container-xxl flex-grow-1 container-p-y">
              <nav class="navbar navbar-example navbar-expand-lg bg-light" style="margin-bottom: 20px;">
                <div class="container-fluid">
                    <a class="navbar-brand" href="javascript:void(0)">Menú</a>
                    <button
                    class="navbar-toggler"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#navbar-ex-3"
                    >
                    <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbar-ex-3">
                        <div class="navbar-nav">
                            <a class="nav-item nav-link active" href="javascript:void(0)">Catalogos / </a>
                            <a class="nav-item nav-link" href="catalogoBLs.php">Catalogo de BLs</a>
                        </div>
                    </div>
                </div>
              </nav>

              <div class="row">
                  <div class="col-12 mb-4">
    
                    <div class="bs-stepper wizard-icons wizard-icons-example mt-2">
                
                      <div class="bs-stepper-header">
                        <div class="step active" data-target="#account-details">
                          <button type="button" class="step-trigger" aria-selected="true">
                            <span class="bs-stepper-icon">
                                <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 56 56" xml:space="preserve"><path d="M-843.16-10.43c0.16,0.54,0.32,1.09,0.47,1.63C-842.84-9.34-843-9.89-843.16-10.43z"/><path d="M-842.69-181.24c-0.15,0.29-0.29,0.59-0.44,0.88C-842.98-180.65-842.83-180.95-842.69-181.24z"/><path d="M-491.73-179.6c-0.16-0.3-0.31-0.6-0.47-0.89C-492.04-180.2-491.88-179.9-491.73-179.6z"/><path d="M-492.2-9.54c0.16-0.29,0.31-0.59,0.47-0.88C-491.88-10.13-492.04-9.84-492.2-9.54z"/><path d="M-543.09-148.1c-0.14,0.27-0.27,0.54-0.41,0.81C-543.36-147.56-543.23-147.83-543.09-148.1z"/><path d="M-675.5-89.01c-0.09-0.24-0.17-0.48-0.26-0.73C-675.68-89.49-675.59-89.25-675.5-89.01z"/><path d="M-659.34-89.8c-0.01,0.26-0.02,0.53-0.03,0.79c-0.08-0.19-0.19-0.37-0.23-0.57C-659.62-89.63-659.44-89.72-659.34-89.8z"/><path class="st2" d="M-827.07-17.17c0.01,0.26,0.02,0.53,0.03,0.79c-0.1-0.19-0.22-0.37-0.29-0.57 C-827.34-16.99-827.16-17.09-827.07-17.17z"/><path d="M-508.07-16.44c0.09-0.24,0.17-0.48,0.26-0.73C-507.89-16.93-507.98-16.69-508.07-16.44z"/><g><path d="M36.73,3.07c2.4,0,4.75,0.01,7.11,0c1.92-0.01,3.32,1.01,3.72,2.96c0.04,0.18,0.03,0.37,0.03,0.55c0,14.88,0,29.75,0,44.63c0,1.96-1.53,3.51-3.48,3.51c-10.81,0-21.63,0-32.44,0c-1.72,0-3.26-1.55-3.26-3.25c0-4.28,0-8.57,0-12.85c0-10.65,0.01-21.29-0.01-31.94c0-1.68,0.91-3.08,2.7-3.57c0.16-0.04,0.33-0.03,0.49-0.03c2.37,0,4.75-0.01,7.12,0.01c0.35,0,0.54-0.1,0.73-0.41c0.5-0.86,1.24-1.38,2.28-1.37c4.15,0,8.31-0.02,12.46,0.01C35.4,1.31,36.24,1.94,36.73,3.07zM39.58,11.08c0,0.63,0.01,1.18,0,1.74c-0.05,1.62-1.31,2.72-2.78,2.72c-5.93-0.01-11.87-0.01-17.8,0c-1.33,0-2.6-1.23-2.57-2.57c0.02-0.62,0-1.25,0-1.87c-1.66-0.09-1.78,0.02-1.78,1.6c0,11.52,0,23.04,0,34.55c0,1,0.22,1.22,1.23,1.22c8.05,0,16.1,0,24.15,0c1.04,0,1.33-0.29,1.33-1.32c0-11.59,0-23.18,0-34.78c0-0.11,0.01-0.22,0-0.33c-0.03-0.56-0.4-0.93-0.96-0.97C40.15,11.07,39.89,11.08,39.58,11.08z M18.36,4.85c-2.06,0-4.11,0.03-6.17-0.01c-1.37-0.02-2,0.81-2,1.99c0.02,14.71,0.02,29.42,0,44.12c0,1.18,0.74,2,2.01,1.99c10.53-0.03,21.07-0.03,31.6,0c1.07,0,2.03-0.68,2.03-2.02c-0.01-14.69-0.01-29.38-0.01-44.07c0-1.32-0.69-2.01-2.02-2.01c-1.91,0-3.82,0-5.73,0c-0.17,0-0.33,0-0.5,0c1.39,0.58,2.12,1.6,2.02,3.05c-0.03,0.46,0,0.91,0,1.32c0.67,0.09,1.31,0.08,1.89,0.28c1.08,0.37,1.68,1.26,1.68,2.65c0,11.76,0,23.52,0,35.28c0,0.07,0,0.15,0,0.22c-0.09,1.57-1.16,2.6-2.47,2.6c-8.49,0.02-16.99,0.01-25.48,0.02c-1.04,0-2.33-1.26-2.33-2.32c0.01-12.11,0-24.22,0.01-36.33c0-0.88,0.9-2.01,1.76-2.18c0.58-0.11,1.18-0.13,1.79-0.19c0-0.54,0.03-1.08-0.01-1.62C16.34,6.43,17.13,5.3,18.36,4.85z M18.24,11.1c-0.02,0.09-0.03,0.12-0.03,0.16c0,0.48,0,0.96,0,1.45c0.01,0.76,0.29,1.05,1.06,1.05c2.04,0,4.08,0,6.12,0c3.75,0,7.49,0,11.24,0c0.66,0,1.09-0.3,1.15-0.9c0.06-0.58,0.01-1.17,0.01-1.76C31.25,11.1,24.76,11.1,18.24,11.1z M27.92,6.63c2,0,4,0,6.01,0c0.83,0,1.19-0.37,1.21-1.21c0-0.35,0-0.7,0-1.06c0-0.93-0.36-1.3-1.28-1.3c-2.08,0-4.15,0-6.23,0c-1.85,0-3.71,0-5.56,0c-0.84,0-1.17,0.33-1.17,1.18c0,0.43,0,0.85,0,1.28c0.01,0.75,0.35,1.1,1.08,1.1C23.95,6.63,25.93,6.63,27.92,6.63z M18.22,9.27c6.56,0,13.06,0,19.59,0c0-0.49,0-0.95,0-1.42c-0.01-0.89-0.43-1.19-1.07-1.2c-0.57,1.2-1.5,1.78-2.86,1.77c-3.89-0.03-7.79-0.04-11.69,0.01c-1.31,0.02-2.23-0.46-2.87-1.58c-0.06-0.11-0.29-0.19-0.43-0.17c-0.45,0.08-0.69,0.36-0.68,0.84C18.22,8.09,18.22,8.67,18.22,9.27z"/><path d="M32.37,21.77c-2.04,0-4.08,0-6.12,0c-0.6,0-0.92-0.31-0.92-0.89c0-0.54,0.36-0.89,0.93-0.89c4.08,0,8.16,0,12.24,0c0.61,0,1.08,0.4,1.07,0.9c-0.01,0.5-0.47,0.88-1.09,0.88C36.46,21.77,34.41,21.77,32.37,21.77z"/><path d="M32.36,28.89c-2.04,0-4.08,0-6.12,0c-0.57,0-0.9-0.31-0.91-0.84c-0.01-0.56,0.33-0.93,0.89-0.93c4.12-0.01,8.24-0.01,12.35,0c0.58,0,1.02,0.43,1,0.91c-0.02,0.49-0.47,0.87-1.04,0.87C36.48,28.89,34.42,28.89,32.36,28.89z"/><path class="st3" d="M32.38,37.8c-2.04,0-4.08,0-6.12,0c-0.6,0-0.92-0.31-0.92-0.88c0-0.54,0.35-0.89,0.93-0.89c4.08,0,8.16,0,12.24,0c0.62,0,1.08,0.4,1.07,0.9c-0.01,0.5-0.47,0.88-1.08,0.88C36.46,37.8,34.42,37.8,32.38,37.8z"/><path d="M32.36,44.92c-2.04,0-4.08,0-6.12,0c-0.57,0-0.9-0.31-0.91-0.84c-0.01-0.56,0.33-0.93,0.89-0.93c4.12-0.01,8.24-0.01,12.35,0c0.58,0,1.02,0.43,1,0.91c-0.02,0.49-0.47,0.87-1.04,0.87C36.48,44.92,34.42,44.92,32.36,44.92z"/><path d="M16.43,27.98c0-0.59,0-1.19,0-1.78c0-0.51,0.32-0.86,0.83-0.87c1.19-0.02,2.37-0.02,3.56,0c0.53,0.01,0.94,0.43,0.94,0.97c0.01,1.13,0.01,2.26,0,3.39c-0.01,0.58-0.42,0.97-0.99,0.97c-1.17,0-2.34,0-3.51,0c-0.52,0-0.84-0.33-0.84-0.85C16.43,29.21,16.43,28.59,16.43,27.98z M18.25,27.13c0,0.62,0,1.19,0,1.72c0.6,0,1.17,0,1.7,0c0-0.6,0-1.17,0-1.72C19.37,27.13,18.81,27.13,18.25,27.13z"/><path d="M16.43,44.04c0-0.61,0-1.22,0-1.84c0-0.47,0.33-0.83,0.8-0.84c1.2-0.02,2.41-0.02,3.61,0c0.5,0.01,0.91,0.43,0.92,0.94c0.02,1.15,0.01,2.3,0,3.45c0,0.48-0.49,0.99-1.02,0.97c-1.15-0.05-2.3-0.01-3.45-0.02c-0.55,0-0.86-0.32-0.87-0.88C16.43,45.23,16.43,44.63,16.43,44.04z M18.24,44.9c0.58,0,1.15,0,1.74,0c0-0.58,0-1.15,0-1.74c-0.58,0-1.15,0-1.74,0C18.24,43.75,18.24,44.31,18.24,44.9z"/><path d="M19.03,20.59c0.84-0.84,1.57-1.58,2.29-2.31c0.37-0.37,0.89-0.39,1.26-0.11c0.45,0.34,0.39,1.01,0.04,1.36c-0.74,0.75-1.49,1.5-2.24,2.24c-0.26,0.25-0.54,0.49-0.83,0.71c-0.39,0.31-0.76,0.27-1.11-0.08c-0.39-0.39-0.79-0.78-1.17-1.18c-0.38-0.4-0.38-0.79-0.02-1.21c0.24-0.28,0.8-0.33,1.16-0.1c0.12,0.08,0.25,0.15,0.35,0.26C18.86,20.27,18.92,20.41,19.03,20.59z"/><path d="M19.05,36.58c0.84-0.84,1.57-1.58,2.3-2.31c0.35-0.35,0.89-0.38,1.22-0.09c0.42,0.37,0.49,0.89,0.1,1.3c-0.93,0.98-1.88,1.94-2.87,2.87c-0.52,0.49-0.97,0.44-1.47-0.06c-0.33-0.33-0.65-0.66-0.98-0.98c-0.52-0.5-0.37-0.99-0.05-1.33c0.27-0.3,0.93-0.29,1.29,0.03C18.75,36.16,18.87,36.36,19.05,36.58z"/></g></svg>
                            </span>
                            <span class="bs-stepper-label">Bill of Lading</span>
                          </button>
                        </div>
                        <div class="line">
                          <i class="bx bx-chevron-right"></i>
                        </div>
                        <div class="step" data-target="#container">
                          <button type="button" class="step-trigger" aria-selected="false">
                            <span class="bs-stepper-icon">
                                <svg version="1.2" baseProfile="tiny" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 56 56" overflow="visible" xml:space="preserve"><path d="M-931.2-10.4c0.2,0.5,0.3,1.1,0.5,1.6C-930.8-9.3-931-9.9-931.2-10.4z"/><path d="M-930.7-181.2c-0.2,0.3-0.3,0.6-0.4,0.9C-931-180.7-930.8-181-930.7-181.2z"/><path d="M-579.7-179.6c-0.2-0.3-0.3-0.6-0.5-0.9C-580-180.2-579.9-179.9-579.7-179.6z"/><path d="M-580.2-9.5c0.2-0.3,0.3-0.6,0.5-0.9C-579.9-10.1-580-9.8-580.2-9.5z"/><path d="M-631.1-148.1c-0.1,0.3-0.3,0.5-0.4,0.8C-631.4-147.6-631.2-147.8-631.1-148.1z"/><path d="M-763.5-89c-0.1-0.2-0.2-0.5-0.3-0.7C-763.7-89.5-763.6-89.3-763.5-89z"/><path d="M-747.3-89.8c0,0.3,0,0.5,0,0.8c-0.1-0.2-0.2-0.4-0.2-0.6C-747.6-89.6-747.4-89.7-747.3-89.8z"/><path d="M-915.1-17.2c0,0.3,0,0.5,0,0.8c-0.1-0.2-0.2-0.4-0.3-0.6C-915.3-17-915.2-17.1-915.1-17.2z"/><path d="M-596.1-16.4c0.1-0.2,0.2-0.5,0.3-0.7C-595.9-16.9-596-16.7-596.1-16.4z"/><g><path d="M54.3,11c1.2-0.1,1.7,0.5,1.7,1.6c0,10.2,0,20.5,0,30.8c0,1.2-0.4,1.7-1.7,1.7c-17.6,0-35.2,0-52.8,0C0.3,45,0,44.7,0,43.5c0-10.4,0-20.8,0-31.1c0-1.1,0.4-1.6,1.5-1.4L54.3,11z M53.5,42.6c0-9.8,0-19.5,0-29.2c-17,0-34,0-51,0c0,9.7,0,19.5,0,29.2C19.5,42.6,36.5,42.6,53.5,42.6z"/><path d="M23.2,15.8c0.8,0,1.5,0,2.4,0c0,8.1,0,16.2,0,24.3c-0.8,0-1.5,0-2.4,0C23.2,32.1,23.2,24,23.2,15.8z"/><path d="M47.4,40.2c-0.8,0-1.5,0-2.3,0c0-8.1,0-16.2,0-24.3c0.8,0,1.5,0,2.3,0C47.4,23.9,47.4,32,47.4,40.2z"/><path d="M37.8,15.8c0.8,0,1.5,0,2.3,0c0,8.1,0,16.2,0,24.3c-0.8,0-1.5,0-2.3,0C37.8,32.1,37.8,24,37.8,15.8z"/><path d="M30.5,15.8c0.8,0,1.5,0,2.3,0c0,8.1,0,16.2,0,24.3c-0.8,0-1.5,0-2.4,0C30.5,32.1,30.5,24,30.5,15.8z"/><path d="M15.9,40.1c0-8.1,0-16.2,0-24.3c0.8,0,1.6,0,2.4,0c0,8.1,0,16.2,0,24.3C17.4,40.1,16.6,40.1,15.9,40.1z"/><path d="M8.5,35.3c0-6.5,0-12.9,0-19.4c0.8,0,1.6,0,2.4,0c0,6.4,0,12.9,0,19.4C10.2,35.3,9.4,35.3,8.5,35.3z"/><path d="M8.5,40.1c0-0.8,0-1.5,0-2.3c0.8,0,1.6,0,2.4,0c0,0.8,0,1.5,0,2.3C10.1,40.1,9.4,40.1,8.5,40.1z"/></g></svg>
                            </span>
                            <span class="bs-stepper-label">Contenedores</span>
                          </button>
                        </div>
                        <div class="line">
                          <i class="bx bx-chevron-right"></i>
                        </div>
                        <div class="step" data-target="#products">
                          <button type="button" class="step-trigger" aria-selected="false">
                            <span class="bs-stepper-icon">
                                <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 56 56" style="enable-background:new 0 0 56 56;" xml:space="preserve"><path class="st0" d="M-931.16-10.43c0.16,0.54,0.32,1.09,0.47,1.63C-930.84-9.34-931-9.89-931.16-10.43z"/><path class="st0" d="M-930.69-181.24c-0.15,0.29-0.29,0.59-0.44,0.88C-930.98-180.65-930.83-180.95-930.69-181.24z"/><path class="st0" d="M-579.73-179.6c-0.16-0.3-0.31-0.6-0.47-0.89C-580.04-180.2-579.88-179.9-579.73-179.6z"/><path class="st0" d="M-580.2-9.54c0.16-0.29,0.31-0.59,0.47-0.88C-579.88-10.13-580.04-9.84-580.2-9.54z"/><path class="st1" d="M-631.09-148.1c-0.14,0.27-0.27,0.54-0.41,0.81C-631.36-147.56-631.23-147.83-631.09-148.1z"/><path class="st2" d="M-763.5-89.01c-0.09-0.24-0.17-0.48-0.26-0.73C-763.68-89.49-763.59-89.25-763.5-89.01z"/><path class="st2" d="M-747.34-89.8c-0.01,0.26-0.02,0.53-0.03,0.79c-0.08-0.19-0.19-0.37-0.23-0.57C-747.62-89.63-747.44-89.72-747.34-89.8z"/><path class="st2" d="M-915.07-17.17c0.01,0.26,0.02,0.53,0.03,0.79c-0.1-0.19-0.22-0.37-0.29-0.57C-915.34-16.99-915.16-17.09-915.07-17.17z"/><path class="st2" d="M-596.07-16.44c0.09-0.24,0.17-0.48,0.26-0.73C-595.89-16.93-595.98-16.69-596.07-16.44z"/><path class="st3" d="M1.77,40.63c-0.01-0.15-0.02-0.3-0.02-0.45c0-8.14,0-16.28,0-24.42c0-0.17,0.02-0.33,0.02-0.5c0.02-0.04,0.04-0.09,0.07-0.13c0.23-0.28,0.41-0.67,0.71-0.82c5.38-2.72,10.77-5.4,16.16-8.1c2.8-1.4,5.59-2.8,8.39-4.19c0.55-0.28,1.12-0.28,1.68,0c8.15,4.08,16.3,8.15,24.43,12.25c0.38,0.19,0.63,0.64,0.94,0.97c0.02,0.04,0.05,0.09,0.07,0.13c0.01,0.13,0.02,0.26,0.02,0.39c0,8.16,0,16.32,0,24.48c0,0.13-0.01,0.26-0.02,0.39c-0.02,0.04-0.05,0.09-0.07,0.13c-0.29,0.33-0.52,0.78-0.89,0.96c-5.36,2.71-10.73,5.39-16.1,8.07c-2.73,1.37-5.47,2.72-8.2,4.11c-0.72,0.37-1.34,0.37-2.07,0.01c-8.1-4.07-16.21-8.11-24.31-12.19c-0.32-0.16-0.51-0.56-0.76-0.85C1.82,40.79,1.79,40.71,1.77,40.63z M29.21,28.78c-0.01,0.01-0.04,0.03-0.04,0.03c0.01,0.03,0.02,0.06,0.03,0.09c0.01,0.2,0.01,0.41,0.01,0.61c0,6.96,0,13.92,0,20.89c0,0.19,0,0.39,0,0.62c0.15-0.06,0.25-0.1,0.34-0.15c4.17-2.08,8.34-4.17,12.51-6.26c3.24-1.62,6.48-3.25,9.72-4.88c0.01-0.04,0.03-0.07,0.04-0.11c-0.01-0.2-0.01-0.41-0.01-0.61c0-6.98,0-13.96,0-20.94c0-0.19,0-0.38,0-0.65c-1.82,0.92-3.54,1.79-5.25,2.66c-0.02,0.04-0.04,0.08-0.06,0.12c0,3.93,0,7.86-0.01,11.79c0,0.24,0,0.49-0.05,0.72c-0.19,0.84-1.16,1.23-1.86,0.74c-1.07-0.74-2.13-1.49-3.22-2.25c-0.93,1.35-1.83,2.68-2.76,4c-0.69,0.98-1.39,1.95-2.12,2.91c-0.31,0.41-0.86,0.39-1.22,0.24c-0.3-0.13-0.59-0.57-0.65-0.91c-0.12-0.63-0.08-1.29-0.08-1.94c-0.01-3.11,0-6.22,0-9.45C32.71,26.99,30.96,27.88,29.21,28.78z M4.17,39.63c-0.01,0.01-0.04,0.03-0.04,0.03c0.01,0.03,0.03,0.06,0.04,0.08c0.12,0.08,0.23,0.16,0.36,0.22c6.26,3.13,12.53,6.26,18.79,9.39c1.13,0.57,2.26,1.13,3.46,1.74c0-0.29,0-0.49,0-0.7c0-3.8,0-7.59,0-11.39c0-3.37,0.01-6.74,0.01-10.11c-0.01-0.04-0.03-0.07-0.04-0.11c-0.04-0.03-0.08-0.07-0.13-0.1c-6.35-3.18-12.71-6.35-19.07-9.53c-1.11-0.56-2.23-1.1-3.38-1.67c0,4.69,0,9.31,0,13.92C4.18,34.15,4.17,36.89,4.17,39.63zM13.7,11.46c0.39,0.2,0.69,0.35,0.99,0.5c6.93,3.47,13.87,6.94,20.81,10.39c0.24,0.12,0.62,0.16,0.85,0.05c2.14-1.03,4.27-2.1,6.47-3.2c-0.85-0.43-1.63-0.82-2.41-1.21c-6.48-3.24-12.96-6.48-19.44-9.73c-0.33-0.16-0.59-0.17-0.91,0c-0.85,0.45-1.72,0.86-2.58,1.29C16.24,10.18,15.01,10.8,13.7,11.46z M33.25,24c-0.07-0.05-0.11-0.09-0.16-0.11c-7.25-3.62-14.49-7.25-21.75-10.85c-0.23-0.11-0.62-0.08-0.86,0.03c-1.17,0.55-2.31,1.15-3.47,1.73c-0.43,0.22-0.86,0.43-1.37,0.68c0.21,0.11,0.34,0.17,0.46,0.24c6.72,3.36,13.46,6.69,20.15,10.12c1.21,0.62,2.17,0.75,3.35,0C30.74,25.11,32.01,24.61,33.25,24zM23.28,6.68c0.1,0.09,0.14,0.15,0.21,0.18c7.23,3.62,14.47,7.24,21.71,10.84c0.18,0.09,0.49,0.05,0.68-0.04c1.45-0.7,2.88-1.42,4.35-2.15c-0.07-0.05-0.13-0.1-0.19-0.14c-7.21-3.61-14.42-7.22-21.64-10.81c-0.24-0.12-0.65-0.1-0.91,0.01c-1.17,0.55-2.31,1.15-3.47,1.73C23.77,6.43,23.54,6.55,23.28,6.68z M36.94,33.21c0.03,0.01,0.07,0.01,0.1,0.02c0.98-1.43,1.96-2.87,2.95-4.3c0.55-0.78,1.19-0.76,1.91-0.34c0.36,0.21,0.67,0.5,1.01,0.74c0.37,0.26,0.74,0.5,1.15,0.77c0-2.98,0-5.86,0-8.78c-0.21,0.09-0.37,0.16-0.54,0.24c-1.78,0.88-3.52,1.84-5.34,2.63c-1.02,0.44-1.42,1.02-1.27,2.11c0.09,0.68,0.02,1.38,0.02,2.06C36.94,29.98,36.94,31.6,36.94,33.21z"/></svg>
                            </span>
                            <span class="bs-stepper-label">Mercancía</span>
                          </button>
                        </div>
                      </div>
                      <div class="bs-stepper-content">
                        <form action="inc/saveBL.php" method="post">
                          <!-- Bill of Lading -->
                          <div id="account-details" class="content active dstepper-block">
                            <div class="row g-3">
                              <div class="col-sm-3">
                                <label class="form-label" for="cliente">Cliente</label>
                                <input type="text" id="cliente" name="cliente" class="form-control" placeholder="Cliente" value="<?php if(isset($_GET["id"])) echo $bl["Cliente"]; ?>" >
                              </div>
                              <div class="col-sm-3">
                                <label class="form-label" for="bl">BL</label>
                                <input type="text" id="bl" name="bl" class="form-control" placeholder="BL" value="<?php if(isset($_GET["id"])) echo $bl["BL"]; ?>" required>
                              </div>
                              <div class="col-sm-3">
                                <label class="form-label" for="buque">Buque</label>
                                <input type="text" id="buque" name="buque" class="form-control" placeholder="Buque" value="<?php if(isset($_GET["id"])) echo $bl["Buque"]; ?>" >
                              </div>
                              <div class="col-sm-3">
                                <label class="form-label" for="destino">Destino</label>
                                <input type="text" id="destino" name="destino" class="form-control" placeholder="Destino" value="<?php if(isset($_GET["id"])) echo mb_convert_encoding($bl["Destino"], 'UTF-8', 'ISO-8859-1'); ?>" >
                              </div>
                              <div class="col-sm-3">
                                <label class="form-label" for="pedimento">Pedimento</label>
                                <input type="text" id="pedimento" name="pedimento" class="form-control" placeholder="Pedimento" value="<?php if(isset($_GET["id"])) echo $bl["Pedimento"]; ?>" >
                              </div>
                              <div class="col-sm-3">
                                <label class="form-label" for="eta">ETA</label>
                                <input type="date" id="eta" name="eta" class="form-control" value="<?php if(isset($_GET["id"])) echo $bl["ETA"]; ?>" required>
                              </div>
                              <div class="col-sm-3">
                                <label class="form-label" for="invoice">Invoice</label>
                                <input type="text" id="invoice" name="invoice" class="form-control" placeholder="Invoice" value="<?php if(isset($_GET["id"])) echo $bl["Cliente"]; ?>" >
                              </div>
                              <div class="col-sm-3">
                                <label class="form-label" for="materialOZ">Material OZ</label>
                                <input type="text" id="materialOZ" name="materialOZ" class="form-control" placeholder="Material OZ" value="<?php if(isset($_GET["id"])) echo $bl["Cliente"]; ?>" >
                              </div>
                              <div class="col-sm-3">
                                <label class="form-label" for="EntregaVacios">Entrega Vacíos</label>
                                <input type="date" id="EntregaVacios" name="EntregaVacios" class="form-control" value="<?php if(isset($_GET["id"])) echo $bl["EntregaVacios"]; ?>" required>
                              </div>
                              <div class="col-sm-3">
                                <label class="form-label" for="status">Status</label>
                                <select name="status" id="status" class="form-select">
                                  <option value="Activos">Activo</option>
                                  <option value="Inactivo">Inactivo</option>
                                </select>
                              </div>
                              <div class="col-12 d-flex justify-content-between">
                                <button type="button" class="btn btn-label-secondary controles btn-prev" disabled="">
                                  <i class="bx bx-chevron-left bx-sm ms-sm-n2"></i>
                                  <span class="align-middle d-sm-inline-block d-none">Anterior</span>
                                </button>
                                <button type="button" class="btn btn-primary controles btn-next">
                                  <span class="align-middle d-sm-inline-block d-none me-sm-1">Siguiente</span>
                                  <i class="bx bx-chevron-right bx-sm me-sm-n2"></i>
                                </button>
                              </div>
                            </div>
                          </div>
                          <!-- Container -->
                          <div id="container" class="content">
                            <div class="row g-3">
                              <div class="col-sm-12">
                                <label class="form-label fw-bold" for="tipoCarga">Tipo de Carga</label>
                                <select name="tipoCarga" id="tipoCarga" class="form-select">
                                  <option value="1">Contenerizada</option>
                                  <option value="2">Carga suelta</option>
                                </select>
                              </div>
                              <div class="col-sm-12">
                                <label class="form-label fw-bold" for="contenedores">Contenedores</label>
                                <p>Agrega un contenedor por línea</p>
                                <textarea name="contenedores" id="contenedores" cols="30" rows="5" class="form-control" placeholder="Contenedor 1
Contenedor 2
Contenedor 3
..."></textarea>
                              </div>
                              <div class="col-sm-12">
                                  <?php
                                  if(isset($_GET["id"])){
                                      $resContenedores = query("SELECT * FROM contenedores WHERE idPL=" . $_GET["id"]);
                                      if($resContenedores){
                                          echo "<table class='table table-striped'><thead><tr class='table-secondary'><th>ID</th><th>Contenedor</th><th>Accion</th></tr></thead><tbody>";
                                          while($row = mysqli_fetch_array($resContenedores))
                                          {
                                              echo "<tr><td>" . $row["idContenedor"]. "</td><td>" . $row["Contenedor"] . "</td><td>  <button type='button' class='btn btn-outline-danger deleteContainer' data-id='" . $row["idContenedor"] . "'><i class='bx bx-trash me-1'></i> Eliminar</button></td></tr>";
                                          }
                                          echo "</tbody></table>";
                                      }
                                  }
                                  ?>
                              </div>
                              <div class="col-12 d-flex justify-content-between">
                                <button type="button" class="btn btn-primary controles btn-prev">
                                  <i class="bx bx-chevron-left bx-sm ms-sm-n2"></i>
                                  <span class="align-middle d-sm-inline-block d-none">Anterior</span>
                                </button>
                                <button type="button" class="btn btn-primary controles btn-next">
                                  <span class="align-middle d-sm-inline-block d-none me-sm-1">Siguiente</span>
                                  <i class="bx bx-chevron-right bx-sm me-sm-n2"></i>
                                </button>
                              </div>
                            </div>
                          </div>
                          <!-- Products -->
                          <div id="products" class="content">
                            <div class="row g-3">
                              <div class="col-sm-2">
                                <label class="form-label" for="address-input">Contenedor</label>
                                <select id="mContenedor" class="form-select"></select>
                              </div>
                              <div class="col-sm-1">
                                <label class="form-label" for="cantidad">Cantidad</label>
                                <input type="number" class="form-control" id="cantidad" placeholder="Cantidad" value="1">
                              </div>
                              <div class="col-sm-2">
                                <label class="form-label" for="ClaveUnidadM">Clave Unidad</label>
                                <select class="form-control basicAutoSelect" id="ClaveUnidadM" name="ClaveUnidadM"
                                    placeholder="Selecciona la unidad..."
                                    data-url="inc/data/c_ClaveUnidad.php" 
                                    autocomplete="off">
                                </select>
                              </div>
                              <div class="col-sm-2">
                                <label class="form-label" for="city">Mercancía</label>
                                <select class="form-control basicAutoSelect" id="BienesTransp" name="BienesTransp"
                                    placeholder="Selecciona la mercancia..."
                                    data-url="inc/data/c_ClaveProdServCP.php"
                                    autocomplete="off">
                                </select>
                              </div>
                              <div class="col-sm-2">
                                  <label class="form-label" for="DescMercancia">Descripcion Mercancia</label>
                                  <input id="DescMercancia" type="text" class="form-control">
                              </div>
                              <div class="col-sm-1">
                                  <label class="form-label" for="PesoEnKg">Peso en Kg</label><br>
                                  <input type="number" id="PesoEnKg" class="form-control" step="0.01" placeholder="0.00">
                              </div>
                              <div class="col-sm-2">
                                  <label class="form-label" for="PesoEnKg">&nbsp;</label><br>
                                  <button type="button" class="btn btn-primary add">Agregar</button>
                              </div>
                
                              <div class="row g-3">
                                <div class="col-sm-12">
                                  <table id="detalleMercancia" class="table">
                                    <thead>
                                      <tr>
                                        <th>Contenedor</th>
                                        <th>Cantidad</th>
                                        <th>Unidad</th>
                                        <th>Mercancia</th>
                                        <th>Descripcion</th>
                                        <th>Peso</th>
                                        <th></th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                  </table>
                                </div>
                              </div>
                
                              <div class="col-12 d-flex justify-content-between">
                                <button type="button" class="btn btn-primary controles btn-prev">
                                  <i class="bx bx-chevron-left bx-sm ms-sm-n2"></i>
                                  <span class="align-middle d-sm-inline-block d-none">Anterior</span>
                                </button>
                                <button class="btn btn-success btn-submit"><?php echo (!isset($_GET["id"])) ? "Guardar" : "Actualizar" ?></button>
                                <input type="hidden" name="submit" value="<?php echo (!isset($_GET["id"])) ? "Guardar" : "Actualizar" ?>">
                                <?php echo (isset($_GET["id"])) ? '<input type="hidden" name="idPL" value="'.$_GET["id"].'">' : ''; ?>
                              </div>
                            </div>
                          </div>
                        </form>
                      </div>
                    </div>
                  </div>
              </div>
            </div>
            <!-- / Content -->

            <!-- Footer -->
            <?php require_once("inc/footer.php");?>
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <!-- Core JS -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/bs-stepper/bs-stepper.js"></script>
    <script src="assets/js/form-wizard-icons.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>

    <!-- Botones. -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>

    <!-- boostrap autocomplete.js -->
    <script src="https://raw.githack.com/xcash/bootstrap-autocomplete/xcash-v300/dist/latest/bootstrap-autocomplete.js"></script>
    <!-- Sweet Alert-->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
      $(document).ready(function() {
        $('.basicAutoSelect').autoComplete();
        
        $('#ClaveUnidadM').autoComplete('set', { value: 'XRO', text: 'XRO - Rollo' });
        $('#BienesTransp').autoComplete('set', { value: '30102004', text: '30102004-Lámina de acero' });

        function getContainers(){
          //Obtener el Tipo de Contenedor
          var tipoContenedor = $('#tipoCarga').val();

          if(tipoContenedor==1){
            // Esperar un breve momento para que el contenido se pegue antes de manipularlo
            setTimeout(function() {
              // Obtener el contenido del textarea
              var contenido = $('#contenedores').val();
    
              // Eliminar saltos de línea vacíos
              contenido = contenido.replace(/^\s*\n/gm, '');
              contenido = contenido.replace(/\n\s*$/gm, '');
    
              // Establecer el contenido modificado de nuevo en el textarea
              $('#contenedores').val(contenido);
    
              // Dividir el contenido en líneas
              var lineas = contenido.split('\n');
    
              // Limpiar el select antes de volver a crear las opciones
              $('#mContenedor').empty();
    
              // Crear opciones para cada línea en el select
              for (var i = 0; i < lineas.length; i++) {
                var opcion = $('<option></option>').text(lineas[i]).val(lineas[i]);;
                $('#mContenedor').append(opcion);
              }
            }, 0);
          }else{
            // Limpiar el select antes de volver a crear las opciones
            $('#mContenedor').empty();

            // Crear la opción Carga suelta
            var opcion = $('<option></option>').text("Carga suelta").val("Carga suelta");;
            $('#mContenedor').append(opcion);
          }
        }

        $('#tipoCarga').on('change', function() { getContainers() });
        $('#contenedores').on('change', function() { getContainers() });
        $('#contenedores').on('paste', function() { getContainers() });

        $('.add').click(function(e) {
          e.preventDefault();

          var registro = '<tr>';
          registro = registro + '<td>'+ $('#mContenedor').val() + '<input type="hidden" name="mContenedorM[]" value="'+ $('#mContenedor').val() + '"></td>';
          registro = registro + '<td>' + $('#cantidad').val() + '<input type="hidden" name="cantidadM[]" value="' + $('#cantidad').val() + '"></td>';
          registro = registro + '<td>'+ $('#ClaveUnidadM').val() + '<input type="hidden" name="ClaveUnidadM[]" value="'+ $("input[name='ClaveUnidadM']").val() + '"></td>';
          registro = registro + '<td>' + $('#BienesTransp').val() + '<input type="hidden" name="BienesTranspM[]" value="' + $("input[name='BienesTransp']").val() + '"></td>';
          registro = registro + '<td>' + $('#DescMercancia').val() + '<input type="hidden" name="DescMercanciaM[]" value="' + $('#DescMercancia').val() + '"></td>';
          registro = registro + '<td>' + $('#PesoEnKg').val() + '<input type="hidden" name="PesoEnKgM[]" value="' + $('#PesoEnKg').val() + '"></td>';
          registro = registro + '<td><a href="#" class="btn btn-danger btn-circle btn-sm remove"><i class="fas fa-trash" value=""></i></a></td>';
          registro = registro + '</tr>';
          registro = registro + '';
          $('#detalleMercancia > tbody').append(registro);
        });

        $('table').on('click','tr a.remove',function(e){
          e.preventDefault();
          $(this).closest('tr').remove();
        });
        
        $('.deleteContainer').on('click', function(e) {
            e.preventDefault();
          
            $(this).data("id");
          
            $.ajax({
                type:'POST',
                data: { id : $(this).data("id") },
                url:'inc/deleteContainer.php',
                success:function(data) {
                    // Cerrar el mensaje de carga después de recibir la respuesta
                    Swal.close();
                    
                    if (data && data.trim() !== '') {
                        respuesta = JSON.parse(data);
                        Swal.fire(respuesta.mensaje, '', respuesta.status);
                    } else {
                        Swal.fire("La respuesta JSON est&aacute; vac&iacute;a o incompleta", '', error);
                    }
                },
                error: function (jqXHR, exception) {
                    // Cerrar el mensaje de carga en caso de error
                    Swal.close();
                    
                    Swal.fire(jqXHR.responseText, '', 'error');
                }
            });
        });
        
        $('.btn-submit').on('click', function(e) {
            e.preventDefault();

            // Muestra un mensaje de error o realiza alguna acción
            var stepper = new Stepper(document.querySelector('.bs-stepper'));
            
            const inputBl = $('#bl')[0]; // Selecciona el control con id "bl"

            // Valida si el control bl tiene información
            if (!inputBl.value.trim()) {
                /// Will navigate to the second step
                stepper.to(1);
                
                // Enfoca el campo para que el usuario lo complete
                inputBl.focus();
                inputBl.reportValidity();
                return;
            }
            
            const inputETA = $('#eta')[0]; // Selecciona el control con id "ETA"

            // Valida si el control ETA tiene información
            if (!inputETA.value.trim()) {
                /// Will navigate to the second step
                stepper.to(1);
                
                // Enfoca el campo para que el usuario lo complete
                inputETA.focus();
                inputETA.reportValidity();
                return;
            }
            
            const inputEntregaVacios = $('#EntregaVacios')[0]; // Selecciona el control con id "EntregaVacios"

            // Valida si el control ETA tiene información
            if (!inputEntregaVacios.value.trim()) {
                /// Will navigate to the second step
                stepper.to(1);
                
                // Enfoca el campo para que el usuario lo complete
                inputEntregaVacios.focus();
                inputEntregaVacios.reportValidity();
                return;
            }
            
            // Obtén el formulario relacionado con el botón
            const form = $(this).closest('form')[0];
            
            // Valida los campos requeridos
            if (form.checkValidity()) {
                // Si la validación es exitosa, envía el formulario vía AJAX
                const formData = $(form).serialize();
                
                $.ajax({
                  url: form.action, // Asegúrate de que el atributo 'action' esté configurado en el formulario
                  type: form.method, // Asegúrate de que el atributo 'method' esté configurado en el formulario
                  data: formData,
                  success: function(response) {
                    // Maneja la respuesta
                    Swal.fire(response, '', 'success');
                  },
                  error: function(err) {
                    console.error('Error al enviar el formulario:', err);
                  }
                });
            } else {
                // Si la validación falla, muestra los errores nativos del navegador
                if(!form.reportValidity()){
                    console.log(form.validationMessage);
                }
                
            }
          
            /*$.ajax({
                type:'POST',
                data: { id : $(this).data("id") },
                url:'inc/saveBL.php',
                success:function(data) {
                    // Cerrar el mensaje de carga después de recibir la respuesta
                    Swal.close();
                    
                    if (data && data.trim() !== '') {
                        respuesta = JSON.parse(data);
                        Swal.fire(respuesta.mensaje, '', respuesta.status);
                    } else {
                        Swal.fire("La respuesta JSON est&aacute; vac&iacute;a o incompleta", '', error);
                    }
                },
                error: function (jqXHR, exception) {
                    // Cerrar el mensaje de carga en caso de error
                    Swal.close();
                    
                    Swal.fire(jqXHR.responseText, '', 'error');
                }
            });*/
        });
        
      });
    </script>
  </body>
</html>